<?php
class AutenticateAPI {

    public $username;
    public $password;
    public $devices = array();

    // Constructor vacío para permitir la instanciación sin parámetros
    public function __construct() {
        // Inicialización opcional si es necesario
    }
    
    // Método de autenticación con parámetros
    public function authenticate($username, $password) {
        // Asignar los valores de parámetros a las propiedades de clase
        $this->username = $username;
        $this->password = $password;

        // Datos de autenticación en formato JSON
        $loginData = json_encode([
            "accountName" => $this->username,
            "password" => $this->password,
            "rememberMe" => true,
            "trustTokens" => [],
            "pause2FA" => true
        ]);

        // URL de autenticación
        $url = "https://idmsa.apple.com.cn/appleauth/auth/signin?widgetKey=d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d";

        // Ejecuta la solicitud POST
        $response = $this->curlPOST($url, $loginData);

        // Extraer X-Apple-Session-Token del encabezado de la respuesta
        if (preg_match('/X-Apple-Session-Token: (.+)/', $response, $matches)) {
            $session_token = trim($matches[1]);
            return $session_token;  // Devuelve el token de sesión si se encuentra
        } else {
            return null;  // Devuelve null si no se encuentra el token
        }
    }

    // Método privado para realizar la solicitud cURL
    private function curlPOST($url, $body) {
        // Inicializa cURL
        $ch = curl_init($url);

        // Configuración de cURL
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        // Encabezados HTTP para la solicitud
        $headers = [
            "Accept: */*",
            "Content-Type: application/json",
            "X-Apple-OAuth-Client-Id: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
            "X-Apple-OAuth-Client-Type: firstPartyAuth",
            "X-Apple-OAuth-Redirect-URI: https://www.icloud.com",
            "X-Apple-OAuth-Require-Grant-Code: true",
            "X-Apple-OAuth-Response-Mode: web_message",
            "X-Apple-OAuth-Response-Type: code",
            "X-Apple-Widget-Key: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
            "User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/603.3.1 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.1"
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Ejecuta la solicitud y obtiene la respuesta
        $response = curl_exec($ch);

        // Cierra la conexión cURL
        curl_close($ch);

        return $response;  // Devuelve la respuesta completa
    }
}
?>
